' Datei fr Attiny-Platine von E. Eube, G. Heinrichs und U. Ihlefeldt
' SPI-Master
' Achtung: MOSI auf PB6, MISO auf PB5, CS auf PB4, FSK mit 10K-Pullup
' rfm12-Transceiver
'
' getestet und funktioniert mit sender1.bas
'
' ******************************* Empfangen ************************************
'
'----------------------------------------------------------------------------

$regfile = "attiny2313.dat"                                 'Attiny2313
$crystal = 4000000                                          '4 MHz
$baud = 9600


'**********************************************************
'******************* Deklarationen ************************

Declare Function Spi(s As Byte) As Byte
Declare Function Rfcommand(byval W As Word) As Word
Declare Function Empfangen() As Byte
Declare Sub Recvinit
Declare Sub Rf12ready
Dim Highbyte As Byte
Dim Lowbyte As Byte
Dim Temp As Word
Dim Datenbyte As Byte
Dim Puffer(10) As Byte
Dim I As Byte
Dim Laenge As Byte

'****************** Initialisierung ***********************

Ddrb = &B11111111                                           'Port B als Ausgangsport
Ddrd = &B01110000                                           'D4, D5, D6 als Ausgang; Rest als Eingang
Portd = &B10001111                                          'Eingnge auf high legen

Portb.4 = 1                                                 'SPI-Chip-Select

'**********************************************************
'******************** Hauptprogramm ***********************

Waitms 100
Call Recvinit
Do
   Laenge = Empfangen()                                     'Laenge maximal 10
   For I = 1 To Laenge
     Datenbyte = Puffer(i)                                  'Printbin Puffer(i) nicht mglich (BUG bei Bascom)
     Printbin Datenbyte
   Next I
Loop



'**********************************************************
'******************* Unterprogramme ***********************

Function Spi(s As Byte) As Byte
  Ddrb = &B11011111
  Usidr = S
  Usisr = &B01000000                                        'USIOIF und Zhler lschen
  Usicr = &B00011010                                        'USIWM0, USICS1,USICLK auf 1
  Do
    Usicr.usitc = 1                                         'Takten durch Setzen von usitc
  Loop Until Usisr.usioif = 1                               '16 mal toggeln
  Spi = Usidr
End Function


Function Rfcommand(w As Word) As Word
   Portb.4 = 0
   Lowbyte = W
   Shift W , Right , 8
   Highbyte = W
   Highbyte = Spi(highbyte)
   Lowbyte = Spi(lowbyte)
   Temp = Highbyte
   Shift Temp , Left , 8
   Rfcommand = Temp + Lowbyte
   Portb.4 = 1
End Function


Sub Recvinit
  Temp = Rfcommand($80d7)
  Temp = Rfcommand($82d9)                                   'einziger unterschied zu sender
  Temp = Rfcommand($a640)
  Temp = Rfcommand($c647)                                   '19200 Baud
  Temp = Rfcommand($94a0)
  Temp = Rfcommand($c2ac)
  Temp = Rfcommand($ca81)
  Temp = Rfcommand($c483)
  Temp = Rfcommand($9850)
  Temp = Rfcommand($e000)
  Temp = Rfcommand($c800)
  Temp = Rfcommand($c400)
End Sub


Function Empfangen() As Byte
  Temp = Rfcommand($ca83)                                   'FiFo aktivieren
  Call Rf12ready
  Temp = Rfcommand($b000)
  Datenbyte = Temp
  For I = 1 To Datenbyte
    Call Rf12ready
    Temp = Rfcommand($b000)
    Puffer(i) = Temp
  Next I
  Temp = Rfcommand($ca81)                                   'FiFo-init
  Empfangen = Datenbyte
End Function


Sub Rf12ready
  Portb.0 = 0
  Portb.4 = 0
  While Pinb.5 = 0
  Wend                                                      'warten bis di = 1, dann TX bereit
  Portb.0 = 1
End Sub


'**********************************************************
'******************Interruptroutinen***********************


'**********************************************************