' Datei fr Attiny-Platine von E. Eube, G. Heinrichs und U. Ihlefeldt
' SPI-Master
' Achtung: MOSI auf PB6, MISO auf PB5, CS auf PB4, FSK mit 10K-Pullup
' rfm12-Transceiver
' Ausgabe auf LCD
'
'
' ******************************* Empfangen ************************************
'
'----------------------------------------------------------------------------

$regfile = "attiny2313.dat"                                 'Attiny2313
$crystal = 4000000                                          '4 MHz
$baud = 9600

$hwstack = 40
$framesize = 30
$swstack = 20


'**********************************************************
'******************* Deklarationen ************************

Declare Function Spi(s As Byte) As Byte
Declare Function Rfcommand(byval W As Word) As Word
Declare Function Empfangen() As Byte
Declare Sub Recvinit
Declare Sub Rf12ready
Dim Highbyte As Byte
Dim Lowbyte As Byte
Dim Temp As Word
Dim Datenbyte As Byte
Dim Zk As String * 10
Dim Puffer(10) As Byte At Zk Overlay
Dim Zeile2 As String * 10
Dim I As Byte
Dim Laenge As Byte
Dim Retteusicr As Byte


Cs Alias Portd.2

'****************** Initialisierung ***********************

Ddrb = &B11011111                                           'Port B als Ausgangsport

Ddrd = &B01110100                                           'D4, D5, D6 als Ausgang; Rest als Eingang
Portd = &B10001111                                          'Eingnge auf high legen

Cs = 1                                                      'SPI-Chip-Select

Config Lcd = 16 * 2                                         'LCD konfigurieren
Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , E = Portb.4 , Rs = Portb.6
Cursor Off
Cls
Zk = "warte..."
Lcd Zk


'**********************************************************
'******************** Hauptprogramm ***********************

Waitms 100
Call Recvinit

Do
   Zeile2 = Zk
   For I = 1 To 10
     Puffer(i) = " "
   Next I
   Laenge = Empfangen()                                     'Laenge maximal 10
   Locate 2 , 1
   Lcd Zeile2
   Locate 1 , 1
   Lcd Zk
Loop


'**********************************************************
'******************* Unterprogramme ***********************

Function Spi(s As Byte) As Byte
' USICR muss gesichert werden, weil LCD-Routinen sonst gestrt werden
  Retteusicr = Usicr
  Usidr = S
  Usisr = &B01000000                                        'USIOIF und Zhler lschen
  Usicr = &B00011010                                        'USIWM0, USICS1,USICLK auf 1
  Do
    Usicr.usitc = 1                                         'Takten durch Setzen von usitc
  Loop Until Usisr.usioif = 1                               '16 mal toggeln
  Usicr = Retteusicr
  Spi = Usidr
End Function


Function Rfcommand(w As Word) As Word
   Cs = 0
   Lowbyte = W
   Shift W , Right , 8
   Highbyte = W
   Highbyte = Spi(highbyte)
   Lowbyte = Spi(lowbyte)
   Temp = Highbyte
   Shift Temp , Left , 8
   Rfcommand = Temp + Lowbyte
   Cs = 1
End Function


Sub Recvinit
  Temp = Rfcommand($80d7)
  Temp = Rfcommand($82d9)                                   'einziger unterschied zu sender
  Temp = Rfcommand($a640)
  Temp = Rfcommand($c647)                                   '19200 Baud
  Temp = Rfcommand($94a0)
  Temp = Rfcommand($c2ac)
  Temp = Rfcommand($ca81)
  Temp = Rfcommand($c483)
  Temp = Rfcommand($9850)
  Temp = Rfcommand($e000)
  Temp = Rfcommand($c800)
  Temp = Rfcommand($c400)
End Sub


Function Empfangen() As Byte
  Temp = Rfcommand($ca83)                                   'FiFo aktivieren
  Call Rf12ready
  Temp = Rfcommand($b000)
  Datenbyte = Temp

  For I = 1 To Datenbyte
    Call Rf12ready
    Temp = Rfcommand($b000)
    Puffer(i) = Temp
  Next I
  Temp = Rfcommand($ca81)                                   'FiFo-init
  Empfangen = Datenbyte
End Function


Sub Rf12ready
  Portd.4 = 0
  Cs = 0
  While Pinb.5 = 0
  Wend                                                      'warten bis di = 1, dann TX bereit
  Portd.4 = 1
End Sub


'**********************************************************
'******************Interruptroutinen***********************


'**********************************************************
'Bemerkung: Die LCD-Funktionen verndern weder PORTB noch DDRB, aber sie
'greifen offensichtlich auf USICR zurck. Wenn dieses Register nicht in
'der SPI-Funktion gerettet wird, kann das LCD nach einem spi-Aufruf nicht
'mehr korrekt angesprochen werden!!!