' Datei fr Attiny-Platine von E. Eube, G. Heinrichs und U. Ihlefeldt
' SPI-Master
' Achtung: MOSI auf PB6, MISO auf PB5,
' CLK auf PB7, CS auf PB4
' rfm12-Transceiver mit 10k als Pullup fr FSK
'
' ******************************* Senden ************************************
'
'----------------------------------------------------------------------------

$regfile = "attiny2313.dat"                                 'Attiny2313
$crystal = 4000000                                          '4 MHz
$baud = 9600
$hwstack = 40
$framesize = 50

'**********************************************************
'******************* Deklarationen ************************

Declare Function Spi(s As Byte) As Byte
Declare Function Rfcommand(byval W As Word) As Word
Declare Sub Transinit
Declare Sub Senden(byval Laenge As Byte)
Declare Sub Tx(byval S As Byte)
Declare Sub Rf12ready
Dim Highbyte As Byte
Dim Lowbyte As Byte
Dim Temp As Word
Dim Datenbyte As Byte
Dim I As Byte
Dim Lzk As Byte
Dim Zk As String * 10
Dim Puffer(10) As Byte At Zk Overlay                        'um auf die einzelnen Bytes von ZK zugreifen zu knnen


'****************** Initialisierung ***********************

Ddrb = &B11111111                                           'Port B als Ausgangsport
Ddrd = &B01110000                                           'D4, D5, D6 als Ausgang; Rest als Eingang
Portd = &B10001111                                          'Eingnge auf high legen

Portb.4 = 1                                                 'SPI-Chip-Select (CS) aus

'**********************************************************
'******************** Hauptprogramm ***********************

Waitms 100                                                  'Sender braucht seine Zeit
Call Transinit
Do
  Input Zk
  Lzk = Len(zk)
  Call Senden(lzk)
Loop



'**********************************************************
'******************* Unterprogramme ***********************

Function Spi(s As Byte) As Byte                             'Hardware-SPI mit USI
  Ddrb = &B11011111
  Usidr = S
  Usisr = &B01000000                                        'USIOIF und Zhler lschen
  Usicr = &B00011010                                        'USIWM0, USICS1,USICLK auf 1
  Do
    Usicr.usitc = 1                                         'Takten durch Setzen von usitc
  Loop Until Usisr.usioif = 1                               '16 mal toggeln
  Spi = Usidr
End Function


Function Rfcommand(w As Word) As Word
   Lowbyte = W
   Shift W , Right , 8
   Highbyte = W
   Portb.4 = 0                                              'CS an
   Highbyte = Spi(highbyte)
   Lowbyte = Spi(lowbyte)
   Portb.4 = 1                                              'CS aus
   Temp = Highbyte
   Shift Temp , Left , 8
   Rfcommand = Temp + Lowbyte
End Function


Sub Transinit
  Temp = Rfcommand($80d7)
  Temp = Rfcommand($8239)
  Temp = Rfcommand($a640)
  Temp = Rfcommand($c647)
  Temp = Rfcommand($94a0)
  Temp = Rfcommand($c2ac)
  Temp = Rfcommand($ca81)
  Temp = Rfcommand($c483)
  Temp = Rfcommand($9850)
  Temp = Rfcommand($e000)
  Temp = Rfcommand($c800)
  Temp = Rfcommand($c400)
End Sub


Sub Tx(s As Byte)
  Temp = $b800 + S
  Call Rf12ready
  Temp = Rfcommand(temp)
End Sub


Sub Senden(laenge As Byte)
  Temp = Rfcommand($8239)

  Call Tx($aa)
  Call Tx($aa)
  Call Tx($aa)
  Call Tx($2d)
  Call Tx($d4)

  If Laenge > 10 Then Laenge = 10
  Call Tx(laenge)

  For I = 1 To Laenge
    Datenbyte = Puffer(i)
    Call Tx(datenbyte)
  Next I

  Call Tx(0)
  Call Tx(0)                                                'Die letzten beiden Bytes gehen verloren, weil nach dem Ausschalten des Transmitters keine Bits mehr aus dem FIFO kommen

  Temp = Rfcommand($8201)                                   'Ausschalten
End Sub


Sub Rf12ready
  Portb.0 = 1
  Portb.4 = 0
  While Pinb.5 = 0
  Wend                                                      'warten bis di = 1, dann TX bereit
  Portb.0 = 0
End Sub


'**********************************************************
'******************Interruptroutinen***********************



'**********************************************************