' Vorlage-Datei fr Attiny-Platine von E. Eube, G. Heinrichs und U. Ihlefeldt
' Attiny als isp-slave
' Kabel von SCK, MISO, MOSI nach PB7, PB6, PB5.
' LEDS an PB0, ..., PB3
' Attiny empfngt Byte ber isp, gibt es an PortB aus (Bit0 bis Bit3) und gibt das Byte (beim nchsten Mal)
' wieder ber isp zurck
'
' Zuerst Master-Programm starten!
'
'----------------------------------------------------------------------------

$regfile = "attiny2313.dat"                                 'Attiny2313
$crystal = 4000000                                          '4 MHz


'**********************************************************
'******************* Deklarationen ************************

Dim S As Byte
Dim E As Byte
Declare Sub Spi

'****************** Initialisierung ***********************

Ddrb = &B11111111                                           'Port B als Ausgangsport
Ddrd = &B01110000                                           'D4, D5, D6 als Ausgang; Rest als Eingang
Portd = &B10001111                                          'Eingnge auf high legen


'**********************************************************
'******************** Hauptprogramm ***********************

Portb = &B11111111                                          'Startsignal
Waitms 100
Portb = &B00000000
Waitms 100

S = 123                                                     'Erste Zahl, die zurckgegeben wird

Do
  Call Spi
  S = E
Loop


'**********************************************************
'******************* Unterprogramme ***********************

Sub Spi
  Ddrb = &B01011111                                         'PB5=DI und PB7=USCK als Eingang
  Usicr = &B00011000                                        'USIWMO (3-wire-mode) und USICS1 (Clock mit pos. Flanke) von USICR auf 1
  Usidr = S                                                 'Sendebyte in USI-Datenregister
  Usisr = &B01000000                                        'USIOIF (Overflow-Flag des Clock-Zhlers) auf 1 (damit es gelscht wird!) und USI-Zhler auf 0
  Do                                                        'Warten bis 8 Clocks
  Loop Until Usisr.usioif = 1
  E = Usidr                                                 'Empfangsbyte aus USI-Datenregister
  Waitms 10
  Ddrb = &B11111111
  Portb = E
End Sub



'**********************************************************
'******************Interruptroutinen***********************




'**********************************************************