# STA-Server zum Schalten einer LED (an Pin 12)

# getestet am 29.06.2020; funktioniert! Hier schon mit Timeout für Request wegen Problem mit Handy-Browser (Chrome)

# Der Parameter "/LED_AN" bzw. "/LED_AUS" bei href wird durch das HTTP-Protokoll als GET-Parameter 
# im Request an den ESP32 gesendet. Indem wir ihn aus der Zeichenkette "request" mit split extrahieren,
# können wir die LED ein- und ausschalten.
# Zum Beenden des Programms Ctrl-C 

# Windows: FireFox-, Chrome- und Edge-Browser funktionieren; auch bei AP
# Handy: Tuts jetzt auch (Chrome und Mi), nachdem das recv-Argument auf 1000 gesetzt wurde!!!

# zusätzliche Beobachtungen:
# Edge fragt nur nach HTML (inzwischen - Ende Juni - wie Chrome)
# Chrome fragt erst nach HTML, dann nach dem fav(orite)icon

# Handy-Chrome baut Verbindung auch schon ohne Request auf!!! Das stört, wenn zwischenzeitlich ein anderer Browser
# eine Anfrage stellen will. Lösung mit Timeout bei Request!

# --> wlan_station_led_server_2.py


import network
import socket
from machine import Pin
from time import time
from sys import exit

# Wlan-Zugangsdaten; hier Ihre Wlan-Daten eintragen:
ssid = 'mipamipa'
password = 'Asdfghjkl1234'

# Konfiguration von LED
led=Pin(12, Pin.OUT)
led.value(1)  # einschalten

def getrequest(connection):
  result = ''
  block_size = 512
  connection.settimeout(5) # führt zu OSError, wenn keine Daten innerhalb von 5 Sekunden empfangen werden, s. u.
  while True:
    data = connection.recv(block_size)
    result += str(data, 'UTF-8')        
    if result.find('\r\n\r\n') >= 0: # Ende des Requests gefunden
      break
  return result

def http_header():
  return '''HTTP/1.1 200 OK\r
Content-Type: text/html\r
Connection: close\r
\r
'''

def html():
  if led.value() == 1:
    led_state = 'AN'
  else:
    led_state = 'AUS'  
  return '''<html>
              <head>
                <title>LED-Server</title>
                <style>button {display: inline-block; background-color: sandyBrown; border: none;
                        border-radius: 6px; color: white; padding: 16px,40px;
                        text-decoration: none; font-size: 30px; cursor: pointer;}
                </style>
              </head>  
              <body> <h1>
                <p> <center> LED ein- und auschalten </center> </p>
                <p> </p>
                <p> LED ist <font color='red'>  
  '''                        + led_state +   '''</font>. <a href='/'> <button>LED-Status?</button> </a></p>
                <p> 
                  Schalte <a href='/LED_AN'> <button>An!</button></a>  
                  <a href='/LED_AUS'> <button>Aus!</button></a>  
                </p>
              </h1> </body>
            </html> 
  '''

# Konfiguration des Wlans:
station = network.WLAN(network.STA_IF)
station.active(True)
station.connect(ssid, password) 
time0 = time()
while (not station.isconnected()) and (time() - time0 < 5):
  pass

if not station.isconnected():
  print('Wlan not connected! SSID and password correct?')
else:  
  print(station.ifconfig())

  # Server bereit stellen
  s = socket.socket()
  try:
    s.bind(('', 80))
    s.listen(5)
    print('Server ready...')
    weiter = True
  except OSError:
    print('OSError when binding')  
    print('Server not ready!')
    print('Please reset!')  
    exit()

  # Daten holen
  while True:
    print('-----------------------------------------')  
    connection, addr = s.accept()
    print("Client connected: ", addr)

    # Request empfangen und auswerten
    try:
      request = getrequest(connection)
      print(request) # zum Testen
      print('Liste: ', request.split(' ')) # nur zum Testen (leer?)
      getparam = request.split(' ')[1] # Element 1 von der Liste ['GET', '/name', ... ], vgl. Kapitel 10    
      print('GET-Parameter: ', getparam) # nur zum Testen
      if getparam == '/LED_AN': 
        led.value(1)
      if getparam == '/LED_AUS':
        led.value(0)
      if getparam == '/favicon.ico':  # nur zum Testen
        print('FAVICON')
      if getparam == '/':  # nur zum Testen
        print('LED State!')  
      connection.send(http_header())
      connection.send(html())
    except OSError as e:
      errno = e.args[0]  
      if errno == 110: # Timeout
        print('getrequest-timeout: OSError 110')
      else: 
        print('OSError: ', errno)
        # eigene Fehler-Behandlung
    finally:  
      connection.close()
      print('connection closed') # nur zum Testen
    # Schleife wird auch bei timeout-Exception fortgesetzt
    
print('Please reset!') # ???????????????????? zu station.isconnected?
# Wlan und Socket s????????????????????????????????????







