# Datei ble_adv_con_0.py

# TTGO als Broadcaster: Überträgt kurze Botschaften (am Terminal eingeben)
# kurz bedeutet: Der gesamte Payload (ohne Adresse) darf max. 31 Bytes lang sein.

# Benutze weiteren TTGO als Observer (ble_observe_0.py)

from time import sleep
import ubluetooth
from micropython import const # not all of the following constants are necessary

_ADV_TYP_NAME = const(9)
_ADV_TYP_MSG = const(250) # Eigener ADV_Typ für Messages

def advertiser(name, msg):
  adv_data = b'\x02\x01\x06'
  name = bytes(name, 'UTF-8')
  adv_data = adv_data +  bytearray((len(name) + 1, _ADV_TYP_NAME)) + name
  msg = bytes(msg, 'UTF-8')
  adv_data = adv_data + bytearray((len(msg)+1, _ADV_TYP_MSG)) + msg
  print(adv_data) # Test
  ble.gap_advertise(200000, adv_data, connectable=False)      
   
 
# Hauptprogramm:

ble = ubluetooth.BLE()
name = 'ESP32'
ble.active(True)

while True:
    msg = input('Eingabe: ')
    advertiser(name, msg)
    sleep(0.1)




