# lm75_2.py
# 24.11.2025
# www.g-heinrichs.de

# nur für nicht negative Temperaturwerte

from time import sleep
from machine import Pin, I2C

i2c = I2C(1, scl = Pin(22), sda = Pin(21), freq = 100_000)
addr = 0x48 # 7-Bit-Adresse im HEX-Format

# Funktionen
def get_value(): 
    raw_value = i2c.readfrom(addr, 2)
    temp_value = raw_value[0] + raw_value[1]/256 # in Grad
    # raw_value[0] = [XXXXXXXX] gibt die ganzen Grade an
    # raw_value[1] = [XXX00000], gibt die 256-tel Grade an
    return temp_value

# Hauptprogramm
while True:
    temperature = get_value()    
    print(temperature, '°C')
    sleep(2)
    