# lm75_3.py
# 24.11.2025
# www.g-heinrichs.de

# auch für negative Temperaturwerte

from time import sleep
from machine import Pin, I2C

i2c = I2C(1, scl = Pin(22), sda = Pin(21), freq = 100_000)
addr = 0x48 # 7-Bit-Adresse im HEX-Format

# Funktionen
def get_value(): 
    raw_value = i2c.readfrom(addr, 2)
    temp_value = raw_value[0]*256 + raw_value[1] # in 256-tel Grad
    # temp_value = 0xC920 # zum Testen (-54,875, vgl. Datasheet, S. 10)
    # raw_value[0] = [XXXXXXXX] gibt die ganzen Grade an
    # raw_value[1] = [XXX00000], gibt die 256-tel Grade an
    sign_bit = temp_value >> 15
    # print(sign_bit) # zum Testen
    if sign_bit == 1:
        temp_value = temp_value - 65536 # (2 << 15)
    temp_value = temp_value / 256    
    return temp_value

# Hauptprogramm
while True:
    temperature = get_value()    
    print(temperature, '°C')
    sleep(2)