# lm75_OS_comp.py
# 28.11.2025
# www.g-heinrichs.de

# OS-LED getestet mit Tos = 30 °C und Thyst = 25 °C und einem Föhn
# Signal an OS-Kontakt getestet: Alles so, wie unten beschrieben!!!
# OS-Signal/OS-LED reagiert auch, wenn programm nicht mehr läuft (aber
# Modul noch mit Strom versorgt wird).

# Idee: 
# Thyst schreiben (Default-Wert: 75 °C)
# nur ganze nicht negative Zahlen
# Tos schreiben (Default-Wert: 80 °C)
# nur ganze nicht negative Zahlen
# OS-Comp ist standardmäßig im Compare_mode; also ist keine Konfiguration nötig.
# Zu Beginn ist der OS-Ausgang inaktiv, d. h. es fließt kein Strom
# und die LED (mit Widerstand) zwischen OS und VCC leuchtet nicht.
# Das Potential am OS-Pin selbst ist daher High (ungefähr VCC).
# Wenn Tos überschritten wird, wird der OS-Ausgang aktiv (d. h. es fließt
# Strom und die LED zwischen OS und VCC leuchtet). Das Potential am OS-Ausgang
# sinkt auf Low (ungefähr GND).
# Erst wenn die gemessene Temperatur danach gleich oder unter Thyst ist,
# wird der OS-Ausgang wieder inaktiv und die LED erlischt.

# vgl. Abb. 8 im Datasheet zu LM75A bzw. Abb. 6 im Datasheet zu LM75B


from time import sleep
from machine import Pin, I2C

i2c = I2C(1, scl = Pin(22), sda = Pin(21), freq = 100_000)
addr = 0x48 # 7-Bit-Adresse im HEX-Format

# Funktionen
def get_value(): # liefert nicht negativen ganzen Temperaturwert
    raw_value = i2c.readfrom(addr, 1)
    temp_value = raw_value[0] # byte -> num
    return temp_value

# Hauptprogramm
# Tos-Wert festlegen
tos_pointer = 3
tos_value = int(input('Tos in °C:'))
tos_value_byte = bytes([tos_value])
i2c.writeto_mem(addr, tos_pointer, tos_value_byte)

# Thyst-Wert festlegen
thyst_pointer = 2 # Thyst
thyst_value = int(input('Thyst in °C:'))
thyst_value_byte = bytes([thyst_value])
i2c.writeto_mem(addr, thyst_pointer, thyst_value_byte)

# Pointer soll wieder auf Temp-Register verweisen
temp_pointer = 0 # Adresse vom Temp-Register
i2c.writeto(addr, bytes([temp_pointer]))

# Mess-Schleife
while True:
    temperature = get_value()    
    print(temperature, '°C')
    sleep(2)
