# lm75_OS_comp_inv.py
# 02.12.2025
# www.g-heinrichs.de

# wie lm75_OS_comp.py, aber mit OS active HIGH, statt LOW
# dazu Bit 2 vom conf-Register (conf_pointer = 1) auf 1 setzen

# npn-Transistor (BC547)
# C - Lämpchen (0,07 A) bzw. Ventilator (0,08 A) - VCC
# B - OS
# E - GND
# Lämpchen bzw. Ventilator geht an (Überhitzungs-Alarm bzw. Kühlung
# einschalten), wenn Tos überschritten wird.
# Lämpchen bzw. Ventilator geht aus, wenn Thyst unterschritten wird.

# vgl. Abb. 8 im Datasheet zu LM75A bzw. Abb. 6 im Datasheet zu LM75B


from time import sleep
from machine import Pin, I2C

i2c = I2C(1, scl = Pin(22), sda = Pin(21), freq = 100_000)
addr = 0x48 # 7-Bit-Adresse im HEX-Format

# Funktionen
def get_value(): # liefert nicht negativen ganzen Temperaturwert
    raw_value = i2c.readfrom(addr, 1)
    temp_value = raw_value[0] # byte -> num
    return temp_value

# Hauptprogramm
# Conf-Wert festlegen
conf_pointer = 1
conf_value = 4 # OS active High
conf_value_byte = bytes([conf_value])
i2c.writeto_mem(addr, conf_pointer, conf_value_byte)

# Tos-Wert festlegen
tos_pointer = 3
tos_value = int(input('Tos in °C:'))
tos_value_byte = bytes([tos_value])
i2c.writeto_mem(addr, tos_pointer, tos_value_byte)

# Thyst-Wert festlegen
thyst_pointer = 2 # Thyst
thyst_value = int(input('Thyst in °C:'))
thyst_value_byte = bytes([thyst_value])
i2c.writeto_mem(addr, thyst_pointer, thyst_value_byte)

# Pointer soll wieder auf Temp-Register verweisen
temp_pointer = 0 # Adresse vom Temp-Register
i2c.writeto(addr, bytes([temp_pointer]))

# Mess-Schleife
while True:
    temperature = get_value()    
    print(temperature, '°C')
    sleep(2)
