# pcf8574_i2c_class_read.py
# 18.11.2025
# www.g-heinrichs.de

# Bit 0 von PCF8574 messen und anzeigen
# Dazu Bit 0 von PCF8574 über Taster mit GND verbinden
# Bei gedrücktem Taster geht Bit 0 auf 0, ansonsten hat es den Wert 1.

from machine import I2C, Pin
from time import sleep_ms

i2c = I2C(1, scl = Pin(22), sda = Pin(21), freq = 100_000)
address = 56 # 7-Bit-Adresse

while True:
    data = i2c.readfrom(address, 1)
    int_data = data[0]
    print(data, int_data, bin(int_data), '   ', end = '')
    bit0 = int_data & 1
    if bit0 == 1:
        print('Taster nicht gedrückt')
    else:
        print('Taster gedrückt')        
    sleep_ms(1000)
    