# pcf8574_i2c_class_write.py
# 17.11.2025
# www.g-heinrichs.de

# LED-Array an PCA8574 angeschlossen; LEDs mit + an 3 V und - an PCF8574-Pins 0 - 7
# PCF8574-Pins werden durch 1-Bit auf 0 gezogen
# Um das Daten-Byte mit den LEDS anzuzeigen, muss es "invertiert" werden.

# Das Programm zeigt mit dem angeschlossenen LED-Array die eingegebene Zahl an.

from machine import I2C, Pin

i2c = I2C(1, scl = Pin(22), sda = Pin(21), freq = 100_000)
address = 56 # 7-Bit-Adresse

data = int(input('Eingabe:'))
data_inv = data ^ 0xFF
data_inv_byte = data_inv.to_bytes(1, 'big')
print('data:', data, '     data_inv:', data_inv, '    data_inv_byte:', data_inv_byte)
i2c.writeto(address, data_inv_byte)

